/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import java.util.Locale;

public enum EnumMetals {
    COPPER(Type.VANILLA_NO_NUGGET, 0.3f),
    ALUMINUM(0.3f),
    LEAD(0.7f),
    SILVER(1.0f),
    NICKEL(1.0f),
    URANIUM(1.0f),
    CONSTANTAN(Type.IE_ALLOY, Float.NaN),
    ELECTRUM(Type.IE_ALLOY, Float.NaN),
    STEEL(Type.IE_ALLOY, Float.NaN),
    IRON(Type.VANILLA, 0.7f),
    GOLD(Type.VANILLA, 1.0f);

    private final Type type;
    public final float smeltingXP;

    private EnumMetals(Type t, float xp) {
        this.type = t;
        this.smeltingXP = xp;
    }

    private EnumMetals(float xp) {
        this.smeltingXP = xp;
        this.type = Type.IE_PURE;
    }

    public boolean isVanillaMetal() {
        return this.type == Type.VANILLA || this.type == Type.VANILLA_NO_NUGGET;
    }

    public boolean isAlloy() {
        return this.type == Type.IE_ALLOY;
    }

    public boolean shouldAddOre() {
        return !this.isVanillaMetal() && !this.isAlloy();
    }

    public boolean shouldAddNugget() {
        return !this.isVanillaMetal() || this.type == Type.VANILLA_NO_NUGGET;
    }

    public String tagName() {
        return this.name().toLowerCase(Locale.US);
    }

    private static enum Type {
        VANILLA,
        VANILLA_NO_NUGGET,
        IE_PURE,
        IE_ALLOY;

    }
}

